<?php
/**
 * @package WordPress
 * @subpackage jPortal
 */


get_header();

?>

<div id="content">
	<?php if (have_posts()) : 
		while (have_posts()) : the_post(); ?>	
			<div class="post" id="post-<?php the_ID(); ?>">
				<h1 class="entry-title">
					<a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a>
				</h1>
				<div class="postmeta"><?php _e('Posted on'); ?>&nbsp;<?php the_time('F jS, Y') ?>&nbsp;<?php printf(__('by %s', 'jPortal'), '<a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="' . sprintf(__('View all posts by %s', 'jPortal'), $authordata->display_name) . '">'.get_the_author().'</a>') ?>&nbsp;<?php _e('in'); ?> <?php the_category(', ') ?></div>
		
				<div class="entry">
					<?php the_content('Read the rest of this entry...'); ?>
					<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
				</div>
		
				<?php if ( comments_open() ) comments_template(); // Get wp-comments.php template ?>
				<?php the_tags(__('<span class="tag-links">Tagged: ', 'jPortal'), ", ", "</span> |") ?>&nbsp;<?php edit_post_link(__('Edit', 'jPortal'), "<span class=\"edit-link\">", "</span>"); ?>
				<?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?>
			</div>
		<?php endwhile;?>
	<?php else : ?>
		<h2 class="center">Not Found</h2>
		<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	<?php endif; ?>
	<!-- end post-page -->
	<?php get_footer(); ?>
</div>
<!-- end container -->
