<?php
/**
 * @package WordPress
 * @subpackage jPortal
 */

get_header();
?>

<div id="content">
	<?php get_sidebar(); ?>
	<div class="mycontent">
		<?php is_tag(); ?>
		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
		<div class="post" id="post-<?php the_ID(); ?>">
			<h1 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'jPortal'), wp_specialchars(get_the_title(), 1)) ?>" rel="bookmark"><?php the_title() ?></a></h1>
			<div class="postmeta"><?php _e('Posted on'); ?>&nbsp;<?php the_time('F jS, Y') ?>&nbsp;<?php printf(__('by %s', 'jPortal'), '<a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="' . sprintf(__('View all posts by %s', 'jPortal'), $authordata->display_name) . '">'.get_the_author().'</a>') ?>&nbsp;<?php _e('in'); ?> <?php the_category(', ') ?></div>
			<div class="entry-content">
				<?php the_content(''.__('Read More <span class="meta-nav">&raquo;</span>', 'jPortal').''); ?>
				<?php wp_link_pages('before=<div class="page-link">' .__('Pages:', 'jPortal') . '&after=</div>') ?>
			</div>

			<div class="entry-meta">
				<span class="comments-link"><?php comments_popup_link(__('Comments (0)', 'jPortal'), __('Comments (1)', 'jPortal'), __('Comments (%)', 'jPortal')) ?></span>
			</div>
		</div><!--post-->
		<?php comments_template(); // Get wp-comments.php template ?>
		<?php the_tags(__('<span class="tag-links">Tagged: ', 'jPortal'), ", ", "</span> |") ?>&nbsp;<?php edit_post_link(__('Edit', 'jPortal'), "<span class=\"edit-link\">", "</span>"); ?>
		<?php endwhile; else: ?>
		<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
		<?php endif; ?>
	</div><!--mycontent-->

	<div class="rightbar">
		<p><center>
		<!-- googleAds-->
			placeholder for the Google AdSense code
		<!-- googleAds-->
		</center></p>
	</div>

</div>

<?php get_footer(); ?>